﻿static const double CCPI[3]={1.0, 63.6619772368, 57.2957795131};
static const double CCPI_1[3]={1.0, 0.01570796326795, 0.01745329252};

sinline u8int numero(float aux, float* limites){
	u8int i;
	if(aux<0) aux=-aux;
	for(i=0;aux>limites[i];i++);	//changed >= to > so that aux=infty does not cause problem
	return i;
}

#include "escritura_float.h"
#include "html_w.h"

/*void escribe_corr_centros(ofstream* finc, u8int idioma, CentroProy* centros, uint ncp, double* DXf, s8int dec, s8int uni, double ccpi){
	uint kk,i;

	finc->setf(ios::fixed);
	switch(idioma){
		case Id_Eng:	(*finc)<<"    Projection centres\n"; break;
		case Id_It:	(*finc)<<"    Centri di proiezione\n"; break;
		default:		(*finc)<<"    Centros de proyección\n";
	}
	(*finc)<<endl;
	for(i=0,kk=0;i<ncp;i++,kk+=6){
		if(!centros[i].b) continue;
		(*finc)<<"    "<<centros[i].fot->nom<<endl;
		(*finc).precision(dec);
		(*finc)<<"    "; (*finc).width(10); (*finc)<<DXf[kk]<<' ';
		(*finc).width(10); (*finc)<<DXf[kk+1]<<' ';
		(*finc).width(10); (*finc)<<DXf[kk+2]<<endl;
		(*finc).precision(6);
		if(uni) (*finc).precision(4);
		(*finc)<<"    "; (*finc).width(10); (*finc)<<DXf[kk+3]*ccpi<<' ';
		(*finc).width(10); (*finc)<<DXf[kk+4]*ccpi<<' ';
		(*finc).width(10); (*finc)<<DXf[kk+5]*ccpi<<endl;
		(*finc)<<endl;
	}
}
void escribe_corr_puntos(ofstream* finc, u8int idioma, PuntoM* puntosM,uint npm, double* DXp, s8int dec, uint* pM_a_pA, PuntoM* puntosA, bint fijas){
	uint i,kk,k;

	finc->setf(ios::fixed);
	switch(idioma){
		case Id_Eng:	(*finc)<<"    Points\n"; break;
		case Id_It:	(*finc)<<"    Punti\n"; break;
		default:		(*finc)<<"    Puntos\n";
	}
	(*finc)<<endl;
	(*finc).precision(dec);
	for(i=0,kk=0;i<npm;i++,kk+=3){
		(*finc)<<"    "; (*finc).width(9); (*finc)<<puntosM[i].nom<<' ';
		if(fijas || pM_a_pA[i]==Я){
			(*finc).width(10); (*finc)<<DXp[kk]<<' ';
			(*finc).width(10); (*finc)<<DXp[kk+1]<<' ';
			(*finc).width(10); (*finc)<<DXp[kk+2]<<endl;
		}else{
			k=puntosA[pM_a_pA[i]].bbb;
			if(k &	1) (*finc)<<"      --    ";
			else{ (*finc).width(10); (*finc)<<DXp[kk]<<' ';}
			if(k &	2) (*finc)<<"      --    ";
			else{ (*finc).width(10); (*finc)<<DXp[kk+1]<<' ';}
			if(k &	4) (*finc)<<"      --    ";
			else{ (*finc).width(10); (*finc)<<DXp[kk+1];}
			(*finc)<<endl;
		}
	}
}*/
void escribe_res_fotogramas(Bufferto8 *finf, bint html, u8int idioma, CentroProy* centros,uint ncp,uint* orden_cp, uint* p_cp_acum, PuntoM* puntosM, int4* mfp, float* L, float* L_norm,
									bint asteriscos, uint* pm_ppios, uint* pM_a_pA, PuntoM* puntosA, float* limites, u8int nasterisco, s8int decf){
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];
	if(html){
		html_H(finf,2,TEXTOS[0],"Res.Fotocoordenadas");
		towrite8_string(finf,"\t<pre>");
	}else{
		towrite8_string(finf,TEXTOS[1]);
	}
	if(decf<=0){finf->prec.absol=-decf; setbuf_absolute(finf);}
	else{finf->prec.signi=(u8int)decf; setbuf_relative(finf);}
	{uint ib; for(ib=0;ib<ncp;ib++){
		uint i,l,ll;
		i=orden_cp[ib];
		if(!centros[i].b) continue;
		if(i) l=p_cp_acum[i-1]; else l=0;
		ll=p_cp_acum[i];
		towrite8(finf,'s',"\n    ", 's',centros[i].fot->nom, '\n',0);
		{uint j; for(j=l;j<ll;j++){
			uint k,kk,pa;

			kk=j<<1;
			k=mfp[j].n1;
			towrite8_string(finf,"    ");
			towrite8_aligned_string(finf,puntosM[k].nom,9); toput_char(finf,' ');
			towrite8_aligned_float(finf,L[kk],10); toput_char(finf,' ');
			towrite8_aligned_float(finf,L[kk+1],10);
			char8_t s[7]="      ";
			if((pa=pM_a_pA[k])!=Я){
				pa=puntosA[pa].bbb;
				if(pa&1) s[3]='X';
				if(pa&2) s[4]='Y';
				if(pa&4) s[5]='Z';
			}
			towrite8_string(finf,s);
			if(asteriscos){
				u8int n;
				uint naux;

				towrite8_string(finf,"  ");
				n=numero(L_norm[kk],limites);
				if(n==0) towrite8_string(finf," .");
				elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
				else towrite8_string(finf," *");
				//
				towrite8_string(finf,"    ");
				n=numero(L_norm[kk+1],limites);
				if(n==0) towrite8_string(finf," .");
				elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
				else towrite8_string(finf," *");

				naux=pm_ppios[k+1]-pm_ppios[k]-1;
				if(naux==2 && (pa==Я || pa==1 || pa==2 || pa==4)) towrite8_string(finf,"    !");
				elif(naux==1) towrite8_string(finf,"    !!");
			}
			toput_char(finf,'\n');
		}}
	}}
	if(html) towrite8_string(finf,"</pre>\n");
}
void escribe_res_apoyo(Bufferto8 *finf, bint html, u8int idioma, PuntoM* puntosA,uint npy,uint* orden_pa, uint* pA_a_pM, float* Lp, float* Lp_norm, bint asteriscos, float* limites, u8int nasterisco, s8int decp){
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];
	if(html){
		html_H(finf,2,TEXTOS[2],"Res.Apoyo");
		towrite8_string(finf,"\t<pre>\n");
	}else{
		towrite8_string(finf,TEXTOS[3]);
	}
	if(decp<=0){finf->prec.absol=-decp; setbuf_absolute(finf);}
	else{finf->prec.signi=(u8int)decp; setbuf_relative(finf);}

	{uint ib; for(ib=0;ib<npy;ib++){
		uint i,kk;
		u8int bb;
		if(orden_pa!=NULL) i=orden_pa[ib];
		else i=ib;
		if(pA_a_pM[i]==Я) continue;
		kk=3*i;
		towrite8_string(finf,"    ");
		towrite8_aligned_string(finf,puntosA[i].nom,9); toput_char(finf,' ');
		bb=puntosA[i].bbb;
		if(bb&1){towrite8_aligned_float(finf,Lp[kk],10); toput_char(finf,' ');}		else towrite8_string(finf,"     --    ");
		if(bb&2){towrite8_aligned_float(finf,Lp[kk+1],10); toput_char(finf,' ');}	else towrite8_string(finf,"     --    ");
		if(bb&4){towrite8_aligned_float(finf,Lp[kk+2],10);}	else towrite8_string(finf,"     --   ");
		if(asteriscos){
			if(bb&1){
				uint n;
				towrite8_string(finf,"  ");
				n=numero(Lp_norm[kk],limites);
				if(n==0) towrite8_string(finf," .");
				elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
				else towrite8_string(finf," *");
			}else towrite8_string(finf,"    ");
			kk++;
			if(bb&2){
				uint n;
				towrite8_string(finf,"  ");
				n=numero(Lp_norm[kk],limites);
				if(n==0) towrite8_string(finf," .");
				elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
				else towrite8_string(finf," *");
			}else towrite8_string(finf,"    ");
			kk++;
			if(bb&4){
				uint n;
				towrite8_string(finf,"  ");
				n=numero(Lp_norm[kk],limites);
				if(n==0) towrite8_string(finf," .");
				elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
				else towrite8_string(finf," *");
			}else towrite8_string(finf,"    ");
		}
		toput_char(finf,'\n');
	}}
	if(html) towrite8_string(finf,"</pre>\n");
}
void escribe_res_control(Bufferto8 *finf, bint html, u8int idioma, PuntoM* puntosC, uint npc, uint* pC_a_pM, float* Lpc, float* Lpc_norm, float* limites, u8int nasterisco, s8int decp){
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];
	if(html){
		html_H(finf,2,TEXTOS[4],"Res.Puntos de control");
		towrite8_string(finf,"\t<pre>\n");
	}else{
		towrite8_string(finf,TEXTOS[5]);
	}
	if(decp<=0){finf->prec.absol=-decp; setbuf_absolute(finf);}
	else{finf->prec.signi=(u8int)decp; setbuf_relative(finf);}

	PuntoM* punpm=puntosC;
	for(uint i=0,kk=0;i<npc;i++,punpm++,kk+=3){
		u8int bb;
		uint l=pC_a_pM[i];
		if(l==Я) continue;
		bb=punpm->bbb;

		towrite8_string(finf,"    ");
		towrite8_aligned_string(finf,punpm->nom,9); toput_char(finf,' ');
		if(bb&1){towrite8_aligned_float(finf,Lpc[kk],10); toput_char(finf,' ');}	else towrite8_string(finf,"     --    ");
		if(bb&2){towrite8_aligned_float(finf,Lpc[kk+1],10); toput_char(finf,' ');}	else towrite8_string(finf,"     --    ");
		if(bb&4){towrite8_aligned_float(finf,Lpc[kk+2],10);}		else towrite8_string(finf,"     --   ");

		if(bb&1){
			u8int n;
			towrite8_string(finf,"  ");
			n=numero(Lpc_norm[kk],limites);
			if(n==0) towrite8_string(finf," .");
			elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
			else towrite8_string(finf," *");
		}else towrite8_string(finf,"    ");
		if(bb&2){
			u8int n;
			towrite8_string(finf,"  ");
			n=numero(Lpc_norm[kk+1],limites);
			if(n==0) towrite8_string(finf," .");
			elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
			else towrite8_string(finf," *");
		}else towrite8_string(finf,"    ");
		if(bb&4){
			u8int n;
			towrite8_string(finf,"  ");
			n=numero(Lpc_norm[kk+2],limites);
			if(n==0) towrite8_string(finf," .");
			elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
			else towrite8_string(finf," *");
		}else towrite8_string(finf,"    ");

		toput_char(finf,'\n');
	}
	if(html) towrite8_string(finf,"</pre>\n");
}
void escribe_res_puntos_elevados(Bufferto8 *finf, bint html, u8int idioma, CentroProy* centros, int2* p_en_cp, uint* pm_ppios, uint npm, uint* orden_L, PuntoM* puntosM, float* L, float* L_norm, uint* pM_a_pA, PuntoM* puntosA, float* limites, u8int nasterisco, s8int decf){
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];
	if(html){
		html_H(finf,2,TEXTOS[16],"Puntos con algún residuo elevado");
		towrite8_string(finf,"\t<pre>");
	}else{
		towrite8_string(finf,TEXTOS[17]);
	}
	if(decf<=0){finf->prec.absol=-decf; setbuf_absolute(finf);}
	else{finf->prec.signi=(u8int)decf; setbuf_relative(finf);}

	for(uint i=0;i<npm;i++){
		uint k,k1,k2,pa;
		k=orden_L[i];
		towrite8_string(finf,"\n    ");
		towrite8_aligned_string(finf,puntosM[k].nom,9);
		k1=pm_ppios[k];
		k2=pm_ppios[k+1]-1;
		//Marca XYZ
		if((pa=pM_a_pA[k])!=Я){
			char8_t s[7]="      ";
			pa=puntosA[pa].bbb;
			if(pa&1) s[3]='X';
			if(pa&2) s[4]='Y';
			if(pa&4) s[5]='Z';
			towrite8_string(finf,s);
		}
		if(k2-k1==2 && (pa==Я || pa==1 || pa==2 || pa==4)) towrite8_string(finf,"    !");
		elif(k2-k1==1) towrite8_string(finf,"    !!");
		toput_char(finf,'\n');

		int2 *pcp_j=p_en_cp+k1;
		while(pcp_j->n1!=Я){
			uint ll;
			uint n;
			ll=pcp_j->n1<<1;
			towrite8_string(finf,"       ");
			towrite8_aligned_string(finf,centros[pcp_j->n2].fot->nom,9); toput_char(finf,' ');
			pcp_j++;
			towrite8_aligned_float(finf,L[ll],10); toput_char(finf,' ');
			towrite8_aligned_float(finf,L[ll+1],10);

			towrite8_string(finf,"  ");
			n=numero(L_norm[ll],limites);
			if(n==0) towrite8_string(finf," .");
			elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
			else towrite8_string(finf," *");
			//
			towrite8_string(finf,"    ");
			n=numero(L_norm[ll+1],limites);
			if(n==0) towrite8_string(finf," .");
			elif(n<nasterisco) towrite8_aligned_uint(finf,n,2);
			else towrite8_string(finf," *");
			toput_char(finf,'\n');
		}
	}
	if(html) towrite8_string(finf,"</pre>\n");
}
void escribe_dist_res(Bufferto8 *finf, u8int idioma, uint* dist_L,u8int nasterisco, uint* dist_Lp,uint* dist_Lgps,uint* dist_Lins){
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];
	towrite8_string(finf,TEXTOS[6]);
	if(nasterisco==0){
		towrite8_string(finf,TEXTOS[7]);
		return;
	}

	float auxb;
	towrite8_string(finf,TEXTOS[8]);
	{uint i; for(i=1;i<nasterisco && i<10;i++) towrite8(finf,'s',"       ", 'u',i,0);}
	{uint i; for(i=10;i<nasterisco;i++) towrite8(finf,'s',"      ", 'u',i,0);}
	towrite8_string(finf,"       *\n\n");

	setbuf_relative(finf);
	towrite8_string(finf,TEXTOS[9]);
	auxb=dist_L[0]/100.0F;
	finf->prec.signi=3;
	{durchlaufei(uint,dist_L+1,nasterisco){
		float aux=*ptri/auxb;
		if(aux<10.F) finf->prec.signi=2;
		towrite8_aligned_float(finf,aux,7); toput_char(finf,' ');
	}}
	toput_char(finf,'\n');
	if(dist_Lp!=NULL){
		towrite8_string(finf,TEXTOS[10]);
		auxb=dist_Lp[0]/100.0F;
		finf->prec.signi=3;
		durchlaufei(uint,dist_Lp+1,nasterisco){
			float aux=*ptri/auxb;
			if(aux<10.F) finf->prec.signi=2;
			towrite8_aligned_float(finf,aux,7); toput_char(finf,' ');
		}
		toput_char(finf,'\n');
	}
	if(dist_Lgps!=NULL){
		towrite8_string(finf,TEXTOS[11]);
		auxb=dist_Lgps[0]/100.0F;
		finf->prec.signi=3;
		durchlaufei(uint,dist_Lgps+1,nasterisco){
			float aux=*ptri/auxb;
			if(aux<10.F) finf->prec.signi=2;
			towrite8_aligned_float(finf,aux,7); toput_char(finf,' ');
		}
		toput_char(finf,'\n');
	}
	if(dist_Lins!=NULL){
		towrite8_string(finf,TEXTOS[12]);
		auxb=dist_Lins[0]/100.0F;
		finf->prec.signi=3;
		durchlaufei(uint,dist_Lins+1,nasterisco){
			float aux=*ptri/auxb;
			if(aux<10.F) finf->prec.signi=2;
			towrite8_aligned_float(finf,aux,7); toput_char(finf,' ');
		}
		toput_char(finf,'\n');
	}
}

void escribe_res_zonas(Bufferto8 *finf, u8int idioma, Puntoxy_float Lzonas[],float σf, bint giroins){
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];

	const char8_t* pal=TEXTOS[13];
	if(σf==0){
		setbuf_relative(finf);
		finf->prec.signi=3;
	}else{
		σf/=2;
		s8int dec=decimales_f(σf);
		setbuf_absolute(finf);
		finf->prec.absol=dec;
	}

	towrite8_string(finf,TEXTOS[14]);
	if(giroins){
		toput_char(finf,'\n');
		towrite8_string(finf,TEXTOS[15]);
	}
#define ZONA(n) \
	if(isfinite(Lzonas[n].x)) towrite8_aligned_float(finf,Lzonas[n].x,7); else towrite8_string(finf,"    -- "); toput_char(finf,' ');\
	if(isfinite(Lzonas[n].y)) towrite8_aligned_float(finf,Lzonas[n].y,7); else towrite8_string(finf,"    -- "); toput_char(finf,'\n');

	towrite8_string(finf,"\n                                          x       y\n\n");
	towrite8_many_strings(finf,"                             ",pal," 0: ",NULL);			ZONA(6)
	towrite8_many_strings(finf,"      |-----|-----|-----|    ",pal," 1: ",NULL);	ZONA(7)
	towrite8_many_strings(finf,"      |  0  |  1  |  2  |    ",pal," 2: ",NULL);		ZONA(8)
	towrite8_many_strings(finf,"      |-----|-----|-----|    ",pal," 3: ",NULL);	ZONA(3)
	towrite8_many_strings(finf,"      |  3  |  4  |  5  |    ",pal," 4: ",NULL);		ZONA(4)
	towrite8_many_strings(finf,"      |-----|-----|-----|    ",pal," 5: ",NULL);	ZONA(5)
	towrite8_many_strings(finf,"      |  6  |  7  |  8  |    ",pal," 6: ",NULL);		ZONA(0)
	towrite8_many_strings(finf,"      |-----|-----|-----|    ",pal," 7: ",NULL);	ZONA(1)
	towrite8_many_strings(finf,"                             ",pal," 8: ",NULL);			ZONA(2)
#undef ZONA
}

void escribe_sis_indent(Bufferto8 *fpar, Sistema *sis, s8int dec){
	const char8_t *s;

	towrite8_string(fpar,"    -sistema\n"
							"      Sistema ");
	if(sis->sis.proy==SIS_Rectangular){
		towrite8_string(fpar,"Rectangular\n");
		return;
	}
	s=NULL;
	if(sis->sis.proy==SIS_Lambert) s="Lambert\n";
	elif(sis->sis.proy==SIS_Mercator) s="Mercator\n";
	elif(sis->sis.proy==SIS_Estereográfica) s="Estereografica\n";
	elif(sis->sis.proy==SIS_Mercator_Transversa) s="UTM\n";
	elif(sis->sis.proy==SIS_Geograficas) s="Geograficas\n";
	if(s!=NULL) towrite8_string(fpar,s);
	else{
		towrite8_string(fpar,"ConformeGenerico");
		fpar->prec.absol=0;
		if(sis->sis.a==sis->sis.e){
			towrite8_string(fpar,"\n      a "); towrite8_double(fpar,sis->sis.a);
		}else{
			towrite8_string(fpar,"\n      N "); towrite8_double(fpar,sis->sis.a);
			towrite8_string(fpar,"\n      rho "); towrite8_double(fpar,sis->sis.e);
			fpar->prec.absol=1;	//convergencia
			towrite8_string(fpar,"\n      param1 "); towrite8_double(fpar,sis->sis.param1.conv0);
		}
		if(dec-2>0) fpar->prec.absol=dec-2;
		else fpar->prec.absol=0;
		towrite8_string(fpar,"\n      ond "); towrite8_double(fpar,sis->sis.ond);
		fpar->prec.absol=7;
		towrite8_string(fpar,"\n      k0 "); towrite8_double(fpar,sis->sis.k0);
		toput_char(fpar,'\n');
		return;
	}
	fpar->prec.absol=0;
	towrite8_string(fpar,"      a "); towrite8_double(fpar,sis->sis.a);
	fpar->prec.absol=9;
	towrite8_string(fpar,"\n      e "); towrite8_double(fpar,sis->sis.e);
	if(dec-2>0) fpar->prec.absol=dec-2;
	else fpar->prec.absol=0;
	towrite8_string(fpar,"\n      ond "); towrite8_double(fpar,sis->sis.ond);
	if(sis->sis.proy==SIS_Geograficas){
		char8_t c;
		if(sis->sis.param1.orden_λφ) c='1';
		else c='0';
		towrite8_string(fpar,"\n      LatLong "); toput_char(fpar,c); toput_char(fpar,'\n');
		return;
	}
	toput_char(fpar,'\n');

	fpar->prec.absol=6;
	towrite8_string(fpar,"      k0 "); towrite8_double(fpar,sis->sis.k0);
	if(sis->sis.proy==SIS_Lambert){
		fpar->prec.absol=9;
		towrite8_string(fpar,"\n      par1 "); towrite8_double(fpar,sis->sis.param1.φ0);
	}
	fpar->prec.absol=dec;
	if(sis->sis.proy!=SIS_Mercator){towrite8_string(fpar,"\n      xO "); towrite8_double(fpar,sis->sis.xO);}
	towrite8_string(fpar,"\n      yS "); towrite8_double(fpar,sis->sis.yS);
	toput_char(fpar,'\n');
}
void escribe_par_centros(Bufferto8 *fo, const char8_t *margen, CentroProy* centros,uint ncp,uint* orden_cp, u8int imu, s8int dec,s8int decz, double ccpi, s8int decg, bint marca){
	if(imu && ccpi<0) ccpi=-ccpi;
	towrite8_string(fo,margen); towrite8_string(fo,"-ccpp\n");
	for(uint ib=0;ib<ncp;ib++){
		uint i;
		CentroProy* puncp;
		PuntoXYZ_double P;
		Giro3D_double G;

		if(orden_cp!=NULL) i=orden_cp[ib];
		else i=ib;
		puncp=centros+i;
		if(!puncp->b) continue;
		P=puncp->P;
		if(imu==0) G=Gmatriz_ωφκ_seg(puncp->M);
		elif(imu==1) G=Gmatriz_imu_x_seg(puncp->M);
		else G=Gmatriz_imu_r_seg(puncp->M);
		towrite8_string(fo,margen); towrite8_aligned_string(fo,puncp->nom,9); toput_char(fo,' ');
		fo->prec.absol=dec;
		towrite8_aligned_double(fo,P.X,13); toput_char(fo,' ');
		towrite8_aligned_double(fo,P.Y,13); toput_char(fo,' ');
		fo->prec.absol=decz;
		towrite8_aligned_double(fo,P.Z,13); toput_char(fo,' ');
		fo->prec.absol=decg;
		towrite8_aligned_double(fo,G.ω*ccpi,11); toput_char(fo,' ');
		towrite8_aligned_double(fo,G.φ*ccpi,11); toput_char(fo,' ');
		towrite8_aligned_double(fo,G.κ*ccpi,11);
		if(marca) towrite8_string(fo,"   1");
		toput_char(fo,'\n');
	}
}
void escribe_par_puntos(Bufferto8 *fo, bint codigo, const char8_t *margen, PuntoM* puntosM,uint npm,uint* orden_pm, s8int dec,s8int decz, bint marca){
	if(codigo){
		towrite8_string(fo,margen); towrite8_string(fo,"-pp\n");
	}

	for(uint ib=0;ib<npm;ib++){
		uint i;
		PuntoM *punpm;

		if(orden_pm!=NULL) i=orden_pm[ib];
		else i=ib;
		punpm=puntosM+i;
		if(!punpm->bbb) continue;

		towrite8_string(fo,margen); towrite8_aligned_string(fo,punpm->nom,9); toput_char(fo,' ');
		fo->prec.absol=dec;
		towrite8_aligned_double(fo,punpm->P.X,13); toput_char(fo,' ');
		towrite8_aligned_double(fo,punpm->P.Y,13); toput_char(fo,' ');
		fo->prec.absol=decz;
		towrite8_aligned_double(fo,punpm->P.Z,13);
		if(marca) towrite8_string(fo,"   1");
		toput_char(fo,'\n');
	}
}

void escribe_precisiones_centros(Bufferto8 *fajs, bint html, u8int idioma, CentroProy* centros,uint ncp,uint* orden_cp, bint todos, double Nf[][36], float vv, s8int dec, float fccpi, s8int decg){
	if(ncp==0) return;
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];
	
	uint ib,nt;
	setbuf_absolute(fajs);
	if(html){
		html_H(fajs,2,TEXTOS[18],"Prec.cc.pp.");
		towrite8_string(fajs,"\t<pre>\n"
					"                    X         Y         Z         &Omega;         &Phi;         K\n\n");
	}else{
		towrite8_string(fajs,TEXTOS[19]);
		towrite8_string(fajs,"                    X         Y         Z         W        PHI        K\n\n");
	}
	if(ncp<=30) todos=1;
	if(todos) nt=ncp;
	else nt=5;
	ib=0;
	for(;;){
		uint i;
		double *pN;

		i=orden_cp[ib];
		if(!centros[i].b) goto next;	//if(nt<nco) nt++;	//causes more troubles than solves
		towrite8_string(fajs,"    "); towrite8_aligned_string(fajs,centros[i].fot->nom,9); toput_char(fajs,' ');
		pN=Nf[i];
		fajs->prec.absol=dec;
		dontimes(3,pN+=7){towrite8_aligned_float(fajs,vv*sqrtf((float)*pN),9); toput_char(fajs,' ');}
		fajs->prec.absol=decg;
		dontimes(3,pN+=7){towrite8_aligned_float(fajs,vv*sqrtf((float)*pN)*fccpi,9); toput_char(fajs,' ');}
		toput_char(fajs,'\n');
next:	if(++ib==nt){
			if(nt==ncp) break;
			towrite8_string(fajs,"         ...\n\n");
			if(nt==5) nt=(ncp+5)>>1;
			else nt=ncp;
			ib=nt-5;
		}
	}
	if(html) towrite8_string(fajs,"</pre>\n");
}
void html_precisiones_medias(Bufferto8 *fajs, u8int idioma,const PrecGrupos *precn){
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];

	html_H(fajs,3,TEXTOS[32],TEXTOS_escrituraf[0][32]);
	if(precn->apoyo.nxy!=0 || precn->apoyo.nz!=0){
		towrite8_many_strings(fajs,TEXTOS[2],"<br>\n\t<br>\n\t<table class=\"values right\">\n"
										"\t\t<tr><td>",TEXTOS[33],NULL);
		if(precn->apoyo.nxy) towrite8_float(fajs,precn->apoyo.xy);	else towrite8_string(fajs,"--");

		towrite8_many_strings(fajs,"\n\t\t<tr><td>",TEXTOS[34],NULL);
		if(precn->apoyo.nz!=0) towrite8_float(fajs,precn->apoyo.z);	else towrite8_string(fajs,"--");
		towrite8_string(fajs,"\n\t</table>\n");
	}
	if(precn->total.n!=0){
		towrite8_many_strings(fajs,"\t<br>\n",TEXTOS[35],
										"<br>\n\t<br>\n\t<table class=\"values right\">\n"
										"\t\t<tr><td>",TEXTOS[36],NULL);
		if(precn->p2.n!=0) towrite8_float(fajs,precn->p2.xy);	else towrite8_string(fajs,"--");
		towrite8_string(fajs,TEXTOS[37]);
		if(precn->p3.n!=0) towrite8_float(fajs,precn->p3.xy);	else towrite8_string(fajs,"--");
		towrite8_string(fajs,TEXTOS[37]);
		if(precn->pn.n!=0) towrite8_float(fajs,precn->pn.xy);	else towrite8_string(fajs,"--"); toput_char(fajs,'\n');
		towrite8_string(fajs,TEXTOS[38]);
		if(precn->p2.n!=0) towrite8_float(fajs,precn->p2.z);	else towrite8_string(fajs,"--");
		towrite8_string(fajs,TEXTOS[39]);
		if(precn->p3.n!=0) towrite8_float(fajs,precn->p3.z);	else towrite8_string(fajs,"--");
		towrite8_string(fajs,TEXTOS[39]);
		if(precn->pn.n!=0) towrite8_float(fajs,precn->pn.z);	else towrite8_string(fajs,"--");
		towrite8_string(fajs,"\n\t</table>\n");

		towrite8_many_strings(fajs,"\t<table class=\"values right\">\n"
											"\t\t<tr><td>",TEXTOS[40],NULL);		towrite8_float(fajs,precn->total.xy);
		towrite8_many_strings(fajs,"\n\t\t<tr><td>",TEXTOS[34],NULL);	towrite8_float(fajs,precn->total.z);
		towrite8_string(fajs,"\n\t</table>\n");
	}
}
void escribe_precisiones_puntos(Bufferto8 *fajs, bint html, u8int idioma, PuntoM* puntosM,uint npm, uint* orden_pm, bint todos, uint* pM_a_pA, PuntoM* puntosA, bint fijas, double Qpp[][9], float vv, s8int dec, bint avisa, uint* pm_ppios, const PrecGrupos *precn){
	if(npm==0) return;
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];

	uint ib,nt;
	bint escribe;
	
	setbuf_absolute(fajs);
	if(html){
		html_H(fajs,2,TEXTOS[20],"Prec.Puntos");
		towrite8_string(fajs,"\t<pre>\n");
	}else{
		towrite8_string(fajs,TEXTOS[21]);
	}
	towrite8_string(fajs,TEXTOS[22]);
	fajs->prec.absol=dec;
	if(npm<=60) todos=true;
	if(todos) nt=npm;
	else nt=8;
	escribe=(bint)(~0U);	//According to the C rules, ~((bint)0) would first convert 0 to int, then ~0 may be a trap representation
	ib=0;						//and the program may even close (as if you had divided by integer zero, for instance), store a zero o do whatever it wants.
	for(;;){
		uint i,j,naux;
		u8int l;
		i=orden_pm[ib];
		naux=pm_ppios[i+1]-pm_ppios[i]-1;
		if(!naux) goto next;

		j=pM_a_pA[i];
		l=0;
		if(j!=Я) l=puntosA[j].bbb;
		if(fijas || j==Я){
			float cosk,sink;

			cosk=(float)Qpp[i][0];
			sink=(float)Qpp[i][4];
			if(escribe){
				towrite8_string(fajs,"    "); towrite8_aligned_string(fajs,puntosM[i].nom,9); toput_char(fajs,' ');
				towrite8_aligned_float(fajs,vv*sqrtf(cosk),9); toput_char(fajs,' ');
				towrite8_aligned_float(fajs,vv*sqrtf(sink),9); toput_char(fajs,' ');
				{float aux=semieje(cosk,sink,(float)Qpp[i][1]);
				towrite8_aligned_float(fajs,vv*sqrtf(aux),9); toput_char(fajs,' ');}
				towrite8_aligned_float(fajs,vv*sqrtf((float)Qpp[i][8]),9); toput_char(fajs,' ');
			}
		}else{
			if(l==7) goto next;
			float cosk,sink,aux;

			aux=sink=cosk=0;
			if(escribe){
				towrite8_string(fajs,"    "); towrite8_aligned_string(fajs,puntosM[i].nom,9); toput_char(fajs,' ');
				if(l&1) towrite8_string(fajs,"     --   ");
				else{
					cosk=vv*sqrtf((float)Qpp[i][0]);
					towrite8_aligned_float(fajs,cosk,9); toput_char(fajs,' ');
				}
				if(l&2) towrite8_string(fajs,"     --   ");
				else{
					sink=vv*sqrtf((float)Qpp[i][4]);
					towrite8_aligned_float(fajs,sink,9); toput_char(fajs,' ');
				}
				if((l&3)==3) towrite8_string(fajs,"     --   ");
				else{
					float aux;
					if(l&3) aux=cosk+sink;
					else{
						aux=semieje_fl((float)Qpp[i][0],(float)Qpp[i][4],(float)Qpp[i][1]);
						aux=vv*sqrtf(aux);
					}
					towrite8_aligned_float(fajs,aux,9); toput_char(fajs,' ');
				}
				if(l&4) towrite8_string(fajs,"     --   ");
				else{
					float aux=vv*sqrtf((float)Qpp[i][8]);
					towrite8_aligned_float(fajs,aux,9); toput_char(fajs,' ');
				}
			}
		}
		if(escribe && avisa){
			char8_t ss[7]="      ";
			if(l){
				if(l&1) ss[3]='X';
				if(l&2) ss[4]='Y';
				if(l&4) ss[5]='Z';
			}
			towrite8_string(fajs,ss);
			if(naux==2 && (l<3 || l==4)) towrite8_string(fajs,"  !");
			elif(naux==1) towrite8_string(fajs,"  !!");
		}
		if(escribe) toput_char(fajs,'\n');
next:	if(++ib==nt){
			if(nt==npm) break;
			if(escribe){
				towrite8_string(fajs,"          ...\n\n");
				if(nt==5) nt=(npm-5)>>1;
				else nt=npm-5;
			}else{
				nt+=5;
			}
	#ifdef TWO_COMP
			escribe=~escribe;
	#else
			escribe=(bint)~(unsigned int)escribe;	//the same for this. It is unvelibable that according to the rules u=~u, for an unsigned u is not what it says.
	#endif
		}
	}
	if(html){
		towrite8_string(fajs,"</pre>\n");
		html_precisiones_medias(fajs,idioma,precn);
		return;
	}
	towrite8_string(fajs,TEXTOS[23]);
	if(precn->apoyo.nxy!=0 || precn->apoyo.nz!=0){
		towrite8_string(fajs,TEXTOS[24]);
		towrite8_string(fajs,TEXTOS[25]);
		if(precn->apoyo.nxy) towrite8_aligned_float(fajs,precn->apoyo.xy,7);
		else towrite8_string(fajs,"     --   ");
		toput_char(fajs,'\n');
		towrite8_string(fajs,TEXTOS[26]);
		if(precn->apoyo.nz) towrite8_aligned_float(fajs,precn->apoyo.z,7);
		else towrite8_string(fajs,"     --   ");
		toput_char(fajs,'\n');
	}
	if(precn->total.n!=0){
		towrite8_string(fajs,TEXTOS[27]);
		towrite8_string(fajs,TEXTOS[25]);
		if(precn->p2.n) towrite8_aligned_float(fajs,precn->p2.xy,7);	else towrite8_string(fajs,"   --  ");
		towrite8_string(fajs,TEXTOS[28]);
		if(precn->p3.n) towrite8_aligned_float(fajs,precn->p3.xy,7);	else towrite8_string(fajs,"   --  ");
		towrite8_string(fajs,TEXTOS[28]);
		if(precn->pn.n) towrite8_aligned_float(fajs,precn->pn.xy,7);	else towrite8_string(fajs,"   --  ");
		toput_char(fajs,'\n');

		towrite8_string(fajs,TEXTOS[26]);
		if(precn->p2.n) towrite8_aligned_float(fajs,precn->p2.z,7);		else towrite8_string(fajs,"   --  ");
		towrite8_string(fajs,TEXTOS[29]);
		if(precn->p3.n) towrite8_aligned_float(fajs,precn->p3.z,7);		else towrite8_string(fajs,"   --  ");
		towrite8_string(fajs,TEXTOS[29]);
		if(precn->pn.n) towrite8_aligned_float(fajs,precn->pn.z,7);		else towrite8_string(fajs,"   --  ");
		toput_char(fajs,'\n');

		towrite8_string(fajs,TEXTOS[30]); towrite8_aligned_float(fajs,precn->total.xy,7);
		towrite8_string(fajs,TEXTOS[31]); towrite8_aligned_float(fajs,precn->total.z,7);
		toput_char(fajs,'\n');
	}
}
void escribe_matrices_centros(Bufferto8 *fpar, u8int idioma, CentroProy* centros,uint ncp,uint* orden_cp, double Nf[][36], float vv, float fccpi, bint correlaciones){
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];

	if(correlaciones){
		setbuf_absolute(fpar);
		fpar->prec.absol=4;
	}else{
		setbuf_relative(fpar);
		fpar->prec.signi=3;
	}
	vv*=vv;
	{const char8_t *s;
	if(!correlaciones) s=TEXTOS[41];
	else s=TEXTOS[42];
	towrite8_string(fpar,s);}

	{uint ib; for(ib=0;ib<ncp;ib++){
		uint i,k2,pos;
		double *pNf;

		i=orden_cp[ib];
		if(!centros[i].b) continue;
		pNf=Nf[i];
		towrite8_many_strings(fpar,"\n    ",centros[i].fot->nom,"\n\n",NULL);
		pos=k2=0;
		{uint j; for(j=0;j<6;j++,k2+=6){
			uint k;
			towrite8_string(fpar,"    ");
			if(!correlaciones){
				for(k=0;k<j;k++)
					towrite8_string(fpar,"             ");
				for(;k<6;k++){
					float faux=(float)pNf[k2+k];
					if(j>2) faux*=fccpi;
					if(k>2) faux*=fccpi;
					towrite8_aligned_float(fpar,vv*faux,12); toput_char(fpar,' ');
				}
			}else{
				float div1;
				uint pos=k2+j;
				for(k=0;k<j;k++)
					towrite8_string(fpar,"         ");
				div1=sqrtf((float)pNf[pos]);
				for(;k<6;k++,pos+=7){
					float faux=(float)pNf[k2+k];
					faux/=div1;
					faux/=sqrtf((float)pNf[pos]);
					towrite8_aligned_float(fpar,faux,8); toput_char(fpar,' ');
				}
			}
			toput_char(fpar,'\n');
		}}
	}}
}
void escribe_matrices_puntos(Bufferto8 *fpar, u8int idioma, PuntoM* puntosM,uint npm, uint* orden_pm, bint fijas, uint* pM_a_pA, double Qpp[][9], float vv, PuntoM* puntosA, bint correlaciones){
	if(idioma>MAX_IDIOMA) idioma=0;
	const char8_t* const *TEXTOS;
	TEXTOS=TEXTOS_escrituraf[idioma];

	if(correlaciones){
		setbuf_absolute(fpar);
		fpar->prec.absol=4;
	}else{
		setbuf_relative(fpar);
		fpar->prec.signi=3;
	}
	vv*=vv;

	{const char8_t *s;
	if(!correlaciones) s=TEXTOS[43];
	else s=TEXTOS[44];
	towrite8_string(fpar,s);}

	{uint ib; for(ib=0;ib<npm;ib++){
		uint i=orden_pm[ib];
		if(!puntosM[i].bbb) continue;
		double *pQ=Qpp[i];

		if(fijas || pM_a_pA[i]==Я){
			uint k1=0;
			towrite8_many_strings(fpar,"\n    ",puntosM[i].nom,"\n\n",NULL);
			{uint j; for(j=0;j<3;j++,k1+=3){
				uint k;
				towrite8_string(fpar,"    ");
				if(!correlaciones){
					for(k=0;k<j;k++)
						towrite8_string(fpar,"             ");
					for(;k<3;k++){
						towrite8_aligned_float(fpar,vv*(float)pQ[k1+k],12); toput_char(fpar,' ');
					}
				}else{
					uint pos,posb;
					float div1;
					pos=k1+j;
					for(k=0;k<j;k++)
						towrite8_string(fpar,"         ");
					div1=sqrtf((float)pQ[pos]);
					posb=pos;
					for(;k<3;k++,posb+=4){
						float faux=(float)pQ[k1+k];
						faux/=div1;
						faux/=sqrtf((float)pQ[posb]);
						towrite8_aligned_float(fpar,faux,8); toput_char(fpar,' ');
					}
				}
				toput_char(fpar,'\n');
			}}
		}else{
			uint k1;
			u8int l=puntosA[pM_a_pA[i]].bbb;
			if(l==7) continue;
			towrite8_many_strings(fpar,"\n    ",puntosM[i].nom,"\n\n",NULL);
			k1=0;
			{uint j; for(j=0;j<3;j++,k1+=3){
				uint k;
				towrite8_string(fpar,"    ");
				if(!correlaciones){
					for(k=0;k<j;k++)
						towrite8_string(fpar,"             ");
					for(;k<3;k++){
						if((l&(1<<j)) || (l&(1<<k))) towrite8_string(fpar,"      --     ");
						else{towrite8_aligned_float(fpar,vv*(float)pQ[k1+k],12); toput_char(fpar,' ');}
					}
				}else{
					uint pos,posb;
					pos=k1+j;
					for(k=0;k<j;k++)
						towrite8_string(fpar,"         ");
					posb=pos;
					for(;k<3;k++,posb+=4){
						if((l&(1<<j)) || (l&(1<<k))) towrite8_string(fpar,"    --   ");
						else{
							float faux,div1;
							faux=(float)pQ[k1+k];
							div1=(float)(pQ[pos]*pQ[posb]);
							faux/=sqrtf(div1);
							towrite8_aligned_float(fpar,faux,8); toput_char(fpar,' ');
						}
					}
				}
				toput_char(fpar,'\n');
			}}
		}
	}}
}

/*ifunlike(nret){
		char16_t* pc=strbuild_mixed(mensaje,'w',S_Elfichero,'c',ficheroori,'w',S_no_se_pudo_abrir_para_escribir,0);
		strcpy16(pc,TEXTOS_fileopen[nret][idioma]);
		return nret;
	}
	ifunlike(fo->error_code){
		strbuild_mixed(mensaje,'w',S_Hubo_un_error_al_escribir_el_fichero,'c',ficheroori,'w',S_El_fichero_generado_no_es_correcto,0);
	}
*/
#define fo (&_fo)
/*FICHEROS DE DIGI*/
#include <time.h>
int escribe_digi_rel(const char16_t* ficheroori, PuntoXYZM_double* centro1, PuntoXYZM_double* centro2, double focal, PuntoXYZ_double* puntosm,uint n, Puntof* puntos1, Puntof* puntos2, int4* mfp1,int4* mfp2,uint* comunes12, s8int dec, double ccpi, s8int d, float x, float y, const char16_t* modelname){
	Bufferto8 _fo;
	PuntoXYZ_double P;
	float vv;

	{int nret=toopen_mixed(fo,ficheroori);
	ifunlike(nret) return nret;}
	fo->prec.absol=dec;

	towrite8_string(fo,"RESULTADOS DE LA ORIENTACIÓN RELATIVA\n");
	towrite8_string(fo,"    "); towrite8_double(fo,focal*0.001);
	towrite8_string(fo,"     "); towrite8_double(fo,focal*0.001); toput_char(fo,'\n');
	towrite8_aligned_float(fo,x*0.001F,11); toput_char(fo,' ');
	towrite8_aligned_float(fo,y*0.001F,11); toput_char(fo,'\t');
	towrite8_aligned_float(fo,x*0.001F,11); toput_char(fo,' ');
	towrite8_aligned_float(fo,y*0.001F,11); toput_char(fo,'\n');
	toput_char(fo,'\n');
#define puncp centro1
	P=puncp->P;
	towrite8_aligned_double(fo,P.X,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,P.Y,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,P.Z,11); toput_char(fo,'\n');
	fo->prec.absol=12;
	{double *ptr=puncp->M[0];
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,'\n'); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,'\n'); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,'\n');}

#undef puncp
#define puncp centro2
	toput_char(fo,'\n');
	fo->prec.absol=dec;
	P=puncp->P;
	towrite8_aligned_double(fo,P.X,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,P.Y,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,P.Z,11); toput_char(fo,'\n');
	fo->prec.absol=12;
	{double *ptr=puncp->M[0];
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,'\n'); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,'\n'); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,'\n');}
#undef puncp

	toput_char(fo,'\n');
	fo->prec.absol=dec;
	towrite8_aligned_double(fo,puntosm->X,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,puntosm->Y,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,puntosm->Z,11); toput_char(fo,'\n');
	toput_char(fo,'\n');
	towrite8_string(fo,"N        -xFizq-     -yFizq-       -xFder-     -yFder-        -xMod-      -yMod-      -zMod-\n");
	{uint* ptr=comunes12;
	PuntoXYZ_double *punP=puntosm;
	 {uint i; for(i=0;i<n;punP++){
		uint k1,k2;
		Puntoxy_double p;
		PuntoXYZ_double P;
		k1=*ptr++; k2=*ptr++;
		i++;
		if(i<10) toput_char(fo,' ');
		toput_char(fo,' '); towrite8_uint(fo,i); toput_char(fo,' ');
		p=puntos1[mfp1[k1].n4].p;
		towrite8_aligned_double(fo,p.x*0.001,13); toput_char(fo,' ');
		towrite8_aligned_double(fo,p.y*0.001,11); toput_char(fo,' ');
		p=puntos2[mfp2[k2].n4].p;
		towrite8_aligned_double(fo,p.x*0.001,13); toput_char(fo,' ');
		towrite8_aligned_double(fo,p.y*0.001,11); toput_char(fo,' ');
		P=*punP;
		towrite8_aligned_double(fo,P.X,13); toput_char(fo,' ');
		towrite8_aligned_double(fo,P.Y,11); toput_char(fo,' ');
		towrite8_aligned_double(fo,P.Z,11); toput_char(fo,'\n');
	}}}
	toput_char(fo,'\n');
	toput_char(fo,'\n');
	towrite8_string(fo,"N        -vXizq-     -vVizq-       -vXder-     -vYder-     -py- (micras)\n");
	fo->prec.absol=1;
	vv=0;
	{uint* ptr=comunes12;
	PuntoXYZ_double *punP=puntosm;
	 {uint i; for(i=0;i<n;punP++){
		uint k1,k2;
		Puntoxy_double ob,calc;
		PuntoXYZ_double Q;
		double (*iM)[3];
		double den;
		float faux;
		k1=*ptr++; k2=*ptr++;
		i++;
		if(i<10) toput_char(fo,' ');
		toput_char(fo,' '); towrite8_uint(fo,i); toput_char(fo,' ');

		ob=puntos1[mfp1[k1].n4].p;
		P_op(Q,=,*punP,-,centro1->P);
		iM=centro1->M;
		den=iM[2][0]*Q.X+iM[2][1]*Q.Y+iM[2][2]*Q.Z;		den=-focal/den;
		calc.x=iM[0][0]*Q.X+iM[0][1]*Q.Y+iM[0][2]*Q.Z;		calc.x*=den;
		calc.y=iM[1][0]*Q.X+iM[1][1]*Q.Y+iM[1][2]*Q.Z;		calc.y*=den;

		faux=(float)(calc.x-ob.x); vv+=faux*faux;
		towrite8_aligned_float(fo,faux,11); toput_char(fo,' ');
		faux=(float)(calc.y-ob.y); vv+=faux*faux;
		towrite8_aligned_float(fo,faux,11); toput_char(fo,' ');

		ob=puntos2[mfp2[k2].n4].p;
		P_op(Q,=,*punP,-,centro2->P);
		iM=centro2->M;
		den=iM[2][0]*Q.X+iM[2][1]*Q.Y+iM[2][2]*Q.Z;		den=-focal/den;
		calc.x=iM[0][0]*Q.X+iM[0][1]*Q.Y+iM[0][2]*Q.Z;		calc.x*=den;
		calc.y=iM[1][0]*Q.X+iM[1][1]*Q.Y+iM[1][2]*Q.Z;		calc.y*=den;

		faux=(float)(calc.x-ob.x); vv+=faux*faux;
		towrite8_aligned_float(fo,faux,13); toput_char(fo,' ');
		faux=(float)(calc.y-ob.y); vv+=faux*faux;
		towrite8_aligned_float(fo,faux,11); toput_char(fo,' ');
		towrite8_aligned_float(fo,2*faux,9); toput_char(fo,'\n');
	}}}
	towrite8_string(fo,"\nPuntos medidos: "); towrite8_uint(fo,n);
	towrite8_string(fo,"\nPuntos rechazados: 0\n"
					"Desviación típica: "); towrite8_float(fo,sqrtf(vv)/(n-3));
	towrite8_string(fo," micras\n"
					"Número de iteraciones: 2\n\n");

	Giro3D_double G;
	fo->prec.absol=d;
	G=Gmatriz_ωφκ(centro1->M);
	towrite8_string(fo,"Giros de la cámara izquierda:\n");
	towrite8_string(fo,"Omega: ");		towrite8_aligned_double(fo,-ccpi*G.ω,9);
	towrite8_string(fo," gon  Phi: ");	towrite8_aligned_double(fo,-ccpi*G.φ,9);
	towrite8_string(fo," gon Kappa: ");	towrite8_aligned_double(fo,-ccpi*G.κ,9);
	towrite8_string(fo," gon\n\n");
	G=Gmatriz_ωφκ(centro2->M);
	towrite8_string(fo,"Giros de la cámara derecha:\n");
	towrite8_string(fo,"Omega: ");		towrite8_aligned_double(fo,-ccpi*G.ω,9);
	towrite8_string(fo," gon  Phi: ");	towrite8_aligned_double(fo,-ccpi*G.φ,9);
	towrite8_string(fo," gon Kappa: ");	towrite8_aligned_double(fo,-ccpi*G.κ,9);
	towrite8_string(fo," gon\n\n"
						"Nombre del modelo: "); towrite8_string16_charred(fo,modelname); toput_char(fo,'\n');

	time_t sys_time=time(NULL);
	struct tm* tm=localtime(&sys_time);
	char8_t fecha[128];
	strftime(fecha,128,"Fecha %d/%m/%y %H:%M:%S\n",tm);
	towrite8_string(fo,fecha);

	toclose(fo);
	return fo->error_code;
}
int escribe_patb_mod(const char16_t* ficheroori, PuntoXYZM_double* centro1,PuntoXYZM_double* centro2, char8_t* nombre1,char8_t* nombre2, PuntoM* puntosM,uint n, s8int dec){
	Bufferto8 _fo;

	{int nret=toopen_mixed(fo,ficheroori);
	ifunlike(nret) return nret;}
	fo->prec.absol=dec;

	{char8_t *c2=nombre2;
	size_t a=strlen8(nombre2);
	if(a>2) c2+=a-2;
	towrite8_aligned_string(fo,nombre1,17);	towrite8_string(fo,c2); toput_char(fo,'\n');}
	towrite8_aligned_string(fo,nombre1,19); toput_char(fo,' ');
	towrite8_aligned_double(fo,centro1->P.X,14); toput_char(fo,' ');
	towrite8_aligned_double(fo,centro1->P.Y,14); toput_char(fo,' ');
	towrite8_aligned_double(fo,centro1->P.Z,14); towrite8_string(fo,"          0\n");
	towrite8_aligned_string(fo,nombre2,19); toput_char(fo,' ');
	towrite8_aligned_double(fo,centro2->P.X,14); toput_char(fo,' ');
	towrite8_aligned_double(fo,centro2->P.Y,14); toput_char(fo,' ');
	towrite8_aligned_double(fo,centro2->P.Z,14); towrite8_string(fo,"          0\n");
	{durchlaufei(PuntoM,puntosM,n){
		towrite8_aligned_string(fo,ptri->nom,19); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptri->P.X,14); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptri->P.Y,14); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptri->P.Z,14); towrite8_string(fo,"          0\n");
	}}
	towrite8_string(fo,"                -99\n");

	toclose(fo);
	return fo->error_code;
}
int escribe_digi_abs(const char16_t* ficheroori, CentroProy* centro1, CentroProy* centro2, double esc, PuntoXYZ_double *puntosrel, PuntoM* puntosT, uint n, s8int dec,s8int decrel, s8int decrot, double ccpi, s8int d, const char16_t* modelname){
	Bufferto8 _fo;
	Giro3D_double G;

	{int nret=toopen_mixed(fo,ficheroori);
	ifunlike(nret) return nret;}

	towrite8_string(fo,"RESULTADOS DE LA ORIENTACIÓN ABSOLUTA\n");
	esc=1/esc;
	{double M[3][3];
	double *ptr;
	Mtransponer(centro1->M,M);
	G=Gmatriz_ωφκ(M);
	fo->prec.absol=dec;
	towrite8_aligned_double(fo,centro1->P.X,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,centro1->P.Y,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,centro1->P.Z,11); toput_char(fo,'\n');
	fo->prec.absol=12;
	towrite8_double(fo,esc); toput_char(fo,'\n');
	ptr=M[0];
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); ptr++;
	towrite8_string(fo,"  Omega: ");
	fo->prec.absol=4; towrite8_aligned_double(fo,G.ω*ccpi,9); toput_char(fo,'\n');
	fo->prec.absol=12;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); ptr++;
	towrite8_string(fo,"    Phi: ");
	fo->prec.absol=4; towrite8_aligned_double(fo,G.φ*ccpi,9); toput_char(fo,'\n');
	fo->prec.absol=12;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); ptr++;
	towrite8_string(fo,"  Kappa: "); fo->prec.absol=4; towrite8_aligned_double(fo,G.κ*ccpi,9); toput_char(fo,'\n');}
	towrite8_string(fo,"\nRESULTADOS DE LA ORIENTACIÓN EXTERNA\n"
						"\nIMAGEN IZQUIERDA\n");
#define puncp centro1
	fo->prec.absol=dec;
	towrite8_aligned_double(fo,puncp->P.X,13); toput_char(fo,' ');
	towrite8_aligned_double(fo,puncp->P.Y,13); toput_char(fo,' ');
	towrite8_aligned_double(fo,puncp->P.Z,13); toput_char(fo,'\n');
	G=Gmatriz_ωφκ(puncp->M);
	{double *ptr=puncp->M[0];
	fo->prec.absol=decrot;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); ptr++;
	towrite8_string(fo,"  Omega: ");
	fo->prec.absol=d;	towrite8_aligned_double(fo,-G.ω*ccpi,9); toput_char(fo,'\n');
	fo->prec.absol=decrot;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); ptr++;
	towrite8_string(fo,"    Phi: ");
	fo->prec.absol=d;	towrite8_aligned_double(fo,-G.φ*ccpi,9); toput_char(fo,'\n');
	fo->prec.absol=decrot;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); ptr++;
	towrite8_string(fo,"  Kappa: ");
	fo->prec.absol=d;	towrite8_aligned_double(fo,-G.κ*ccpi,9); toput_char(fo,'\n');}

	towrite8_string(fo,"\nIMAGEN DERECHA\n");
#undef puncp
#define puncp centro2
	fo->prec.absol=dec;
	towrite8_aligned_double(fo,puncp->P.X,13); toput_char(fo,' ');
	towrite8_aligned_double(fo,puncp->P.Y,13); toput_char(fo,' ');
	towrite8_aligned_double(fo,puncp->P.Z,13); toput_char(fo,'\n');
	G=Gmatriz_ωφκ(puncp->M);
	{double *ptr=puncp->M[0];
	fo->prec.absol=decrot;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); ptr++;
	towrite8_string(fo,"  Omega: ");
	fo->prec.absol=d;	towrite8_aligned_double(fo,-G.ω*ccpi,9); toput_char(fo,'\n');
	fo->prec.absol=decrot;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); ptr++;
	towrite8_string(fo,"    Phi: ");
	fo->prec.absol=d;	towrite8_aligned_double(fo,-G.φ*ccpi,9); toput_char(fo,'\n');
	fo->prec.absol=decrot;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,10); ptr++;
	towrite8_string(fo,"  Kappa: ");
	fo->prec.absol=d;	towrite8_aligned_double(fo,-G.κ*ccpi,9); toput_char(fo,'\n');}
#undef puncp
	towrite8_string(fo,"\nPUNTO   -XT-       -YT-     -ZT-     -xi-     -yi-     -zi-    -Ex-   -Ey-   -Ez-\n");
	durchlaufe2(PuntoXYZ_double,puntosrel,n,PuntoM,puntosT){
		PuntoXYZ_double Q;
		towrite8_aligned_string(fo,ptr_b->nom,6); toput_char(fo,' ');
		fo->prec.absol=dec;
		towrite8_aligned_double(fo,ptr_b->P.X,10); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptr_b->P.Y,10); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptr_b->P.Z,7); toput_char(fo,' ');
		fo->prec.absol=decrel;
		towrite8_aligned_double(fo,ptr->X,8); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptr->Y,8); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptr->Z,8); toput_char(fo,' ');
		GiraPuntoM_inv(Q,centro1->M,*ptr); P_mul(Q,esc);
		P_eq(Q,+=,centro1->P);
		P_eq(Q,-=,ptr_b->P);
		fo->prec.absol=dec;
		towrite8_aligned_double(fo,Q.X,6); toput_char(fo,' ');
		towrite8_aligned_double(fo,Q.Y,6); toput_char(fo,' ');
		towrite8_aligned_double(fo,Q.Z,6); toput_char(fo,'\n');
	}
	towrite8_string(fo,"\nNombre del modelo: "); towrite8_string16_charred(fo,modelname);

	time_t sys_time=time(NULL);
	struct tm* tm=localtime(&sys_time);
	char8_t fecha[128];
	strftime(fecha,128,"Fecha %d/%m/%y %H:%M:%S\n",tm);
	towrite8_string(fo,fecha);

	toclose(fo);
	return fo->error_code;
}

//El sistema que recibe esta función tiene l1 y phi1 del sistema local del par
int escribe_Digi_abs2(const char16_t* ficheroori, Sistema* sis, PuntoXYZM_double *Interno_a_rel,double esc, PuntoXYZ_double *puntosrel, PuntoM *puntosM, PuntoM *puntosT, uint n, s8int dec,s8int decrel, double ccpi, const char16_t* modelname){
	Bufferto8 _fo;
	Giro3D_double G;
	double M[3][3];

	{int nret=toopen_mixed(fo,ficheroori);
	ifunlike(nret) return nret;}

	towrite8_string(fo,"ORIENTACIÓN ABSOLUTA\n");
	fo->prec.absol=dec;
	esc=1/esc;

	Mtransponer(Interno_a_rel->M,M);
	G=Gmatriz_ωφκ(M);
	towrite8_aligned_double(fo,Interno_a_rel->P.X,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,Interno_a_rel->P.Y,11); toput_char(fo,' ');
	towrite8_aligned_double(fo,Interno_a_rel->P.Z,11); toput_char(fo,'\n');
	fo->prec.absol=12;
	towrite8_double(fo,esc); toput_char(fo,'\n');
	{double *ptr=M[0];
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); ptr++;
	towrite8_string(fo,"  Omega: ");
	fo->prec.absol=4; towrite8_aligned_double(fo,G.ω*ccpi,9); toput_char(fo,'\n');
	fo->prec.absol=12;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); ptr++;
	towrite8_string(fo,"    Phi: ");
	fo->prec.absol=4; towrite8_aligned_double(fo,G.φ*ccpi,9); toput_char(fo,'\n');
	fo->prec.absol=12;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); toput_char(fo,' '); ptr++;
	towrite8_aligned_double(fo,*ptr,17); ptr++;
	towrite8_string(fo,"  Kappa: "); fo->prec.absol=4; towrite8_aligned_double(fo,G.κ*ccpi,9); toput_char(fo,'\n');}

	switch(sis->sis.proy){
		case 0: toput_char(fo,'0'); toput_char(fo,'\n'); break;
		case 5: toput_char(fo,'2'); break;
		case 10: toput_char(fo,'1'); toput_char(fo,'0'); break;
		default: toput_char(fo,'1');
	}
	if(!sis->sis.proy) goto no_proy;
	fo->prec.absol=dec;
	toput_char(fo,' '); towrite8_double(fo,sis->local.proy.x);
	toput_char(fo,' '); towrite8_double(fo,sis->local.proy.y);
	toput_char(fo,' '); towrite8_double(fo,sis->sis.ond);
	if(sis->sis.proy==SIS_Mercator_Transversa || sis->sis.proy==SIS_Geograficas){
		toput_char(fo,' '); towrite8_double(fo,sis->sis.a);
		 fo->prec.absol=9; toput_char(fo,' '); towrite8_double(fo,sis->sis.e);
		if(sis->sis.proy==SIS_Geograficas){
			towrite8_string(fo," unknown\n");
		}else{
			fo->prec.absol=7; toput_char(fo,' '); towrite8_double(fo,sis->sis.k0);
			fo->prec.absol=dec;
			toput_char(fo,' '); towrite8_double(fo,sis->sis.xO);
			toput_char(fo,' '); towrite8_double(fo,sis->sis.yS);
			towrite8_string(fo," -3.0  unknown 30 0\n");
		}
	}else{
		double N,ρ,k0;
		if(sis->sis.proy==SIS_Conforme){N=sis->sis.a; ρ=sis->sis.e;}
		else{
			double sinphi=sin(sis->local.geog.y);
			N=radN(sis->sis.a,sis->sis.e,sinphi);
			ρ=N*ρ_by_N(sis->sis.e,sinphi);
		}
		if(sis->sis.proy==SIS_Lambert) k0=1;//kLambert_l(sis,sis->local.geog.y);	¡Que lo programe él! Estoy harto de tener que programar
		elif(sis->sis.proy==SIS_Mercator) k0=1;//kMercator_l(sis,sis->local.geog.y);	workarounds a Aerotri para que Digi funcione bien,
		elif(sis->sis.proy==SIS_Estereográfica) k0=1;//kEstereo_l(sis,sis->local.geog.y);	y por culpa de esto necesitaría sistemas.dll para escritura_de_ficheros
		else k0=sis->sis.k0;
		//dec sigue en vigor
		toput_char(fo,' '); towrite8_double(fo,N);
		toput_char(fo,' '); towrite8_double(fo,ρ);
		fo->prec.absol=7; toput_char(fo,' '); towrite8_double(fo,k0);
		towrite8_string(fo," 0 0 0 0 0\n");
	}
no_proy:
	towrite8_string(fo,"POINT   -XT-       -YT-     -ZT-     -xi-     -yi-     -zi-    -Ex-   -Ey-   -Ez-\n");
	float vv=0;
	PuntoM *punpm=puntosM;
	durchlaufe2(PuntoXYZ_double,puntosrel,n,PuntoM,puntosT){
		PuntoXYZ_double Q;
		towrite8_aligned_string(fo,ptr_b->nom,6); toput_char(fo,' ');
		fo->prec.absol=dec;
		towrite8_aligned_double(fo,ptr_b->P.X,9); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptr_b->P.Y,10); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptr_b->P.Z,7); toput_char(fo,' ');
		fo->prec.absol=decrel;
		towrite8_aligned_double(fo,ptr->X,8); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptr->Y,8); toput_char(fo,' ');
		towrite8_aligned_double(fo,ptr->Z,8); toput_char(fo,' ');
		GiraPuntoM_inv(Q,Interno_a_rel->M,*ptr); P_mul(Q,esc);
		P_eq(Q,+=,Interno_a_rel->P);
		P_eq(Q,-=,punpm->P);	punpm++;
		fo->prec.absol=dec;
		towrite8_aligned_double(fo,Q.X,6); toput_char(fo,' ');
		towrite8_aligned_double(fo,Q.Y,6); toput_char(fo,' ');
		towrite8_aligned_double(fo,Q.Z,6); toput_char(fo,'\n');
		vv+=(float)P_mod(Q);
	}
	fo->prec.absol=dec;
	towrite8_string(fo,"\nEM.= "); towrite8_float(fo,sqrtf(vv)/(n-4));
	towrite8_string(fo,"\nNombre del modelo: "); towrite8_string16_utf8(fo,modelname);

	time_t sys_time=time(NULL);
	struct tm* tm=localtime(&sys_time);
	char8_t fecha[128];
	strftime(fecha,128,"Fecha %d/%m/%y %H:%M:%S\n",tm);
	towrite8_string(fo,fecha);

	toclose(fo);
	return fo->error_code;
}

/*FICHEROS DE IMAGE MASTER*/
int escribe_imaster_ext(const char16_t* ficheroori, CentroProy* centro){
	Bufferto8 _fo;
	//Global *global=Globales+thread_to_i(GetThreadId());
	Giro3D_double G;

	{int nret=toopen_mixed(fo,ficheroori);
	ifunlike(nret) return nret;}
	fo->prec.absol=6;
	G=Gmatriz_κφω_seg(centro->M);
	towrite8_string(fo,"PI3_EXT_FILEVER1.0\n");
	towrite8_double(fo,centro->P.X); toput_char(fo,'\n');
	towrite8_double(fo,centro->P.Y); toput_char(fo,'\n');
	towrite8_double(fo,centro->P.Z); toput_char(fo,'\n');
	towrite8_double(fo,G.ω*CCPI[2]); toput_char(fo,'\n');
	towrite8_double(fo,G.φ*CCPI[2]); toput_char(fo,'\n');
	towrite8_double(fo,G.κ*CCPI[2]); toput_char(fo,'\n');

	toclose(fo);
	return fo->error_code;
}
int escribe_imaster_rel(const char16_t* ficheroori, char8_t* nombre1, char8_t* nombre2, PuntoXYZM_double* centro1,double N1[][3], PuntoXYZM_double* centro2,double N2[][3]){
	Bufferto8 _fo;
	//Global *global=Globales+thread_to_i(GetThreadId());
	double M[3][3];
	Giro3D_double G;

	{int nret=toopen_mixed(fo,ficheroori);
	ifunlike(nret) return nret;}
	fo->prec.absol=6;

	towrite8_string(fo,"PI3_REL_FILEVER1.0\n");
	towrite8_string(fo,nombre1); toput_char(fo,'\n');
	towrite8_string(fo,nombre2); toput_char(fo,'\n');

	mmulrot_inv(centro1->M,N1,M);
	G=Gmatriz_ωφκ_seg(M);
	towrite8_string(fo,"0.000000\n0.000000\n0.000000\n");
	towrite8_double(fo,-G.ω*CCPI[2]); toput_char(fo,'\n');
	towrite8_double(fo,-G.φ*CCPI[2]); toput_char(fo,'\n');
	towrite8_double(fo,-G.κ*CCPI[2]); toput_char(fo,'\n');
	mmulrot_inv(centro2->M,N2,M);
	G=Gmatriz_ωφκ_seg(M);
	towrite8_string(fo,"1.000000\n0.000000\n0.000000\n");
	towrite8_double(fo,-G.ω*CCPI[2]); toput_char(fo,'\n');
	towrite8_double(fo,-G.φ*CCPI[2]); toput_char(fo,'\n');
	towrite8_double(fo,-G.κ*CCPI[2]); toput_char(fo,'\n');

	toclose(fo);
	return fo->error_code;
}

//modo:
//	0: sólo los pares principales de las pasadas principales
//	1: todos los pares de las pasadas ppales con nmin puntos
//	2: todos los pares según las direcciones principales y secundarias con >=nmin
//	3: todos los pares >=nmin.
//
//orden: orden en que se escriben los pares en el archivo .pairlist
//	0: Por fotogramas, según el orden de los cc.pp. del ajuste
//	1: Primero los pares principales de las pasadas, al final los otros pares
//	2: Por pasadas, intercalando todos los pares de los que forme parte cada fotograma de cada pasada principal.
//		Al final, los de las fotos que no forman parte de ninguna pasada principal
//
//duplicar: si se escriben ambos pares f1,f2 y f2,f1
int escribe_imaster_pairlist(const char16_t* ficheroori, CentroProy* centros, uint ncp, ParesdeFotos paresFF, Pasadas pasadas, u8int orden, u8int modo, bint duplicar){
	Bufferto8 _fo;
	bint *listo;
	static const u8int nivel_modo[5]=\
		{TIPOPAR_PASPPAL,TIPOPAR_OTROPPAL,TIPOPAR_OTROSEC,TIPOPAR_SUELTO};

	{int nret=toopen_mixed(fo,ficheroori);
	ifunlike(nret) return nret;}

	towrite8_string(fo,"STEREOPAIRLIST_1.00\n");
	modo=nivel_modo[modo];
	listo=NULL;
	if(orden==2 && modo>TIPOPAR_PASPPAL){
		listo=n_malloc(bint,ncp);
		if(listo==NULL) orden=1;
		else zeroset_bint(listo,ncp);
	}
	if(orden){
		int3 *ptri=pasadas.ppios;
		while(ptri->n1!=Я){
			uint *pcp;
			u8int bpas;
			bint brev;

			bpas=(u8int)ptri->n2;
			if(PASADAn2_EJE(bpas)!=pasadas.eje_principal && (modo<TIPOPAR_PASSEC || orden==2)){ptri++; continue;}
			brev=(bint) ptri->n3;
			pcp=pasadas.ccpp+ptri->n1;	ptri++;
			if(!(orden==2 && modo>TIPOPAR_PASPPAL)){
				uint ll=*pcp++;
				while(*pcp!=Я){
					uint k1,k2;
					uint l=ll;
					ll=*pcp++;
					if(!brev){k1=l; k2=ll;}
					else{k1=ll; k2=l;}
					towrite8_string(fo,centros[k1].fot->nom); toput_char(fo,',');
					towrite8_string(fo,centros[k2].fot->nom); toput_char(fo,'\n');
					if(duplicar){
						towrite8_string(fo,centros[k2].fot->nom); toput_char(fo,',');
						towrite8_string(fo,centros[k1].fot->nom); toput_char(fo,'\n');
					}
				}
			}else{
				if(PASADAn2_PRIMERA(bpas)) pcp++;	//Escribir sólo este par. No completar la foto. Nos la podemos saltar porque ya se escribirá entre los pares de la foto siguiente
				while(*pcp!=Я){
					uint l;
					char8_t* nom;
					int2 *ppares, *ptrj;
					u8int modo_run;

					l=*pcp++;													//Lo mismo para la última. Por lo tanto en una pasada consistente en un único par
					if(*pcp==Я && PASADAn2_ULTIMA(bpas)) break;	//formado por dos fotos, ambas fuera de su pasada principal, dicho par se omite.
					if(listo[l]) continue;										//Ya se escribirá (o se escribió) cuando se llegue a alguna de las dos fotos en su pasada principal
					nom=centros[l].fot->nom;
					ppares=paresFF.fotos+paresFF.ppios[l];

					modo_run=0;
			repares:
					modo_run+=2;
					for(ptrj=ppares;ptrj->n1!=Я;ptrj++){
						u8int nivel;
						char8_t *s1, *s2;

						if(listo[ptrj->n1]) continue;
						nivel=(u8int)(ptrj->n2&0x7F);
						if(nivel==TIPOPAR_PASPPAL || nivel==TIPOPAR_OTROPPAL) nivel=2;
						elif(nivel==TIPOPAR_PASSEC || nivel==TIPOPAR_OTROSEC) nivel=4;
						else nivel=6;
						if(nivel!=modo_run) continue;

						s2=centros[ptrj->n1].fot->nom;
						if(!(ptrj->n2&0x80)) s1=nom;
						else{s1=s2; s2=nom;}
						towrite8_string(fo,s1); toput_char(fo,',');
						towrite8_string(fo,s2); toput_char(fo,'\n');
						if(duplicar){
							towrite8_string(fo,s2); toput_char(fo,',');
							towrite8_string(fo,s1); toput_char(fo,'\n');
						}
					}
					if(modo_run<modo) goto repares;
					listo[l]=1;
				}
			}
		}
	}
	//Pares de dos fotos que no entran ninguna en ninguna pasada principal
	if(orden==2){
	    if(modo>=TIPOPAR_PASSEC){
		Durchlaufei_fwd(bint,listo,ncp){
			char8_t* nom;
			int2 *ppares;
			if(*ptri++) continue;
			nom=centros[i].fot->nom;
			ppares=paresFF.fotos+paresFF.ppios[i];
			for(;ppares->n1!=Я;ppares++){
				char8_t *s1,*s2;
				if(listo[ppares->n1]) continue;
				{u8int nivel=ppares->n2&0x7F; if(nivel>modo) continue;}
				s2=centros[ppares->n1].fot->nom;
				if(!(ppares->n2&0x80)) s1=nom;
				else{s1=s2; s2=nom;}
				towrite8_string(fo,s1); toput_char(fo,',');
				towrite8_string(fo,s2); toput_char(fo,'\n');
				if(duplicar){
					towrite8_string(fo,s1); toput_char(fo,',');
					towrite8_string(fo,s2); toput_char(fo,'\n');
				}
			}
		}
	    }
	//Pares de fotos que no son los principales de pasada (para orden=1), o todos (para orden=0).
	}elif(!orden || modo>TIPOPAR_PASPPAL){
		int2 *ppares=paresFF.fotos;
		CentroProy *puncp=centros;
		dontimes(ncp,){
			char8_t *nom=puncp->fot->nom; puncp++;
			for(;ppares->n1!=Я;ppares++){
				char8_t *s1,*s2;
				u8int nivel=ppares->n2&0x7F;
				if(nivel>modo || (orden && (nivel==TIPOPAR_PASPPAL || nivel==TIPOPAR_PASSEC)) ) continue;
				s2=centros[ppares->n1].fot->nom;
				if(!(ppares->n2&0x80)) s1=nom;
				else{s1=s2; s2=nom;}
				towrite8_string(fo,s1); toput_char(fo,',');
				towrite8_string(fo,s2); toput_char(fo,'\n');
				if(duplicar){
					towrite8_string(fo,s2); toput_char(fo,',');
					towrite8_string(fo,s1); toput_char(fo,'\n');
				}
			}
			ppares++;
		}
	}
	freeif(listo);

	toclose(fo);
	return fo->error_code;
}
#undef fo
